<?php $__env->startSection('content'); ?>
<main class="main">

    <!-- Page Title -->
    <div class="page-title">
        <div class="breadcrumbs">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"><i class="bi bi-house"></i> Home</a></li>
                    <li class="breadcrumb-item active current">lowongan kerja Perusahaan</li>
                </ol>
            </nav>
        </div>

        <div class="title-wrapper">
            <h1>Melamar Kerja</h1>

        </div>
    </div><!-- End Page Title -->

    <!-- Service Details Section -->
    <section id="service-details" class="service-details section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-12">

                    <div class="content mt-5">

                        <h3>PT. AQILLA HUMAENI INDONESIA (AHI)</h3>
                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>
                        <div class="container">
                            <form action="/submission" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id_career" value="<?php echo e($data->id); ?>">
                                <input type="hidden" name="career_name" value="<?php echo e($data->name); ?>">
                                <p>Lowongan yang di lamar : <strong><?php echo e($data->name); ?></strong></p>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="nik" class="form-label">NIK</label>
                                        <input type="text" class="form-control" id="nik" name="nik" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label">Nama Lengkap</label>
                                        <input type="text" class="form-control" id="name" name="name" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="wa" class="form-label">Nomor WhatsApp</label>
                                        <input type="text" class="form-control" id="wa" name="wa" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="gender" class="form-label">Jenis Kelamin</label>
                                        <select class="form-select" id="gender" name="gender" required>
                                            <option value="">Pilih...</option>
                                            <option value="L">Laki-laki</option>
                                            <option value="P">Perempuan</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="birthday" class="form-label">Tanggal Lahir</label>
                                        <input type="date" class="form-control" id="birthday" name="birthday" required>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="address" class="form-label">Alamat</label>
                                    <textarea class="form-control" id="address" name="address" rows="3"
                                        required></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">

                                        <label for="document" class="form-label">Dokumen Ijazah (PDF)</label>
                                        <input class="form-control" type="file" id="document" name="document"
                                            accept="application/pdf" required>

                                    </div>
                                    <div class="col-md-6 mb-3 mt-2">

                                        <?php
                                        app('mathcaptcha')->reset();
                                        ?>
                                        <label for="mathgroup">Masukan hasil dari: <?php echo e(app('mathcaptcha')->label()); ?></label>
                                        <?php echo app('mathcaptcha')->input(['class' => 'form-control', 'id' => 'mathgroup']); ?>

                                        <?php if($errors->has('mathcaptcha')): ?>
                                        <span class="help-block">
                                            <strong><?php echo e($errors->first('mathcaptcha')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Kirim</button>
                            </form>
                        </div>
                    </div>
                </div>


            </div>

        </div>

    </section><!-- /Service Details Section -->

</main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/aqilla/resources/views/daftar.blade.php ENDPATH**/ ?>