@extends('index')
@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title">
        <div class="breadcrumbs">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"><i class="bi bi-house"></i> Home</a></li>
                    <li class="breadcrumb-item active current">Service Details</li>
                </ol>
            </nav>
        </div>

        <div class="title-wrapper">
            <h1>Layanan Kami</h1>
            <p>Berikut layanan yang ada di PT. AHI</p>
        </div>
    </div><!-- End Page Title -->

    <!-- Service Details Section -->
    <section id="service-details" class="service-details section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-8">
                    <div class="service-details-slider swiper init-swiper">
                        <script type="application/json" class="swiper-config">
                            {
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "slidesPerView": 1,
                  "pagination": {
                    "el": ".swiper-pagination",
                    "type": "bullets",
                    "clickable": true
                  }
                }
                        </script>
                        <div class="swiper-wrapper align-items-center">
                            @foreach ($service as $data)
                            <div class="swiper-slide">
                                <img src="{{asset('storage/'.$data->image)}}" alt="" class="img-fluid" loading="lazy">
                            </div>
                            @endforeach


                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                    @foreach ($service as $data)
                    <div class="content mt-5">

                        <h3>{{$data->title}}</h3>
                        <p>
                            {!!$data->description!!}
                        </p>


                    </div>
                    @endforeach
                </div>

                <div class="col-lg-4">
                    <div class="service-info">
                        <h4>Service Information</h4>
                        <div class="info-item">
                            <i class="bi bi-envelope"></i>
                            <h5>Email</h5>
                            <p>{{$contact->email}}</p>
                        </div>
                        <div class="info-item">
                            <i class="bi bi-geo-alt"></i>
                            <h5>Alamat</h5>
                            <p>{{$contact->address}}</p>
                        </div>
                        <div class="info-item">
                            <i class="bi bi-telephone"></i>
                            <h5>Contact Support</h5>
                            <p>{{$contact->phone}}</p>
                        </div>
                    </div>


                </div>

            </div>

        </div>

    </section><!-- /Service Details Section -->

</main>
@endsection