@extends('index')
@section('content')
<main class="main">

    <!-- Page Title -->
    <div class="page-title">
        <div class="breadcrumbs">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/"><i class="bi bi-house"></i> Home</a></li>
                    <li class="breadcrumb-item active current">buku tamu Perusahaan</li>
                </ol>
            </nav>
        </div>

        <div class="title-wrapper">
            <h1>Buku Tamu</h1>

        </div>
    </div><!-- End Page Title -->

    <!-- Service Details Section -->
    <section id="service-details" class="service-details section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-12">

                    <div class="content mt-5">

                        <h3>PT. AQILLA HUMAENI INDONESIA (AHI)</h3>
                        @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        @if (session('message'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('message') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        <div class="container">
                            <form action="/guestsubmit" method="post" enctype="multipart/form-data">
                                @csrf

                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label for="name" class="form-label">Nama Lengkap</label>
                                        <input type="text" class="form-control" id="name" name="name" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="wa" class="form-label">Nomor WhatsApp</label>
                                        <input type="text" class="form-control" id="wa" name="wa" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="wa" class="form-label">Instansi Asal</label>
                                        <input type="text" class="form-control" id="instansi" name="instansi" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="wa" class="form-label">Bertemu:</label>
                                        <select name="bertemu" required class="form-control">
                                            @foreach ($user as $data)
                                            <option value="{{$data->id}}">{{$data->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mb-3">

                                        <label for="keperluan" class="form-label">Keperluan</label>
                                        <textarea class="form-control" id="keperluan" name="keperluan" rows="3"
                                            required></textarea>
                                    </div>
                                </div>


                                <div class="col-md-6 mb-3 mt-2">

                                    @php
                                    app('mathcaptcha')->reset();
                                    @endphp
                                    <label for="mathgroup">Masukan hasil dari: {{
                                        app('mathcaptcha')->label() }}</label>
                                    {!! app('mathcaptcha')->input(['class' => 'form-control', 'id' => 'mathgroup'])
                                    !!}
                                    @if ($errors->has('mathcaptcha'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mathcaptcha') }}</strong>
                                    </span>
                                    @endif
                                </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Kirim</button>
                        </form>
                    </div>
                </div>
            </div>


        </div>

        </div>

    </section><!-- /Service Details Section -->

</main>
@endsection