<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('submissions', function (Blueprint $table) {
            //
            $table->unsignedBigInteger('id_career')->nullable()->after('id'); // Tambahkan kolom id_career
            $table->string('career_nama')->nullable()->after('id_career'); // Tambahkan kolom career_nama

            $table->foreign('id_career')->references('id')->on('careers')->onDelete('set null'); // Tambahkan foreign key
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('submissions', function (Blueprint $table) {
            //
            $table->dropForeign(['id_career']); // Hapus foreign key
            $table->dropColumn('id_career'); // Hapus kolom id_career
            $table->dropColumn('career_nama');
        });
    }
};
